
*******************************************************************************************************
***     ANALYSIS:  Capturing Multiple Perspectives in a Multi-actor Survey: 						***
***				   The Impact of Parental Presence in Child Interviews on Reporting Discrepancies 	***	
***		DATA:      Pairfam Waves 1 to 9, Release 9.1 						  			  			***
***																									***	
*** 	CONTENT:   - Sample characteristics full sample, Section 3.2						  		***
***				   - Descriptive statistics on parental presence, Section 4.1			  			***	
***				   - Tables 1 and 2, Section 4.1											  		***							
***				   - Appendix Table A1 and Appendix Figure A1  				  				  		***
*******************************************************************************************************

clear all
set maxvar 15000
set more off
set varabbrev off

global path1 `""datapath""'  
global path2 `""outputpath""'  
global path3 `""syntaxpath""'  


cd $path1	
use parentpres.dta, clear


***************************************************************
*** 	Sample characteristics, full sample  (Section 3.2)  ***
***************************************************************

*** Parent-child dyads with at least one observation in waves 6 to 9 

** Number of child-parent dyads and observations
cap drop py*
bysort cid (wave): gen pynrc = _n           	// observation ID (within child-parent dyad)
bysort id (wave): gen pynr = _n           		// observation ID (within child-parent dyad)
bysort cid: gen pycount = _N   					// # of observations (within child-parent dyad)

cap drop n
gen n=cid-id-200	
gen sib0=0
bysort id (cid): replace sib0 = 1 if n>n[_n-1]
bysort id: egen sib=max(sib0)  

count											// N=3,924 observations
tab pynrc if pynrc==1, m						// N=1,823 child-parent dyads
tab pynr										// N=1,291 anchor households


** Parent-child dyads with at least one observations in waves 7 and 9 

cd $path1	
use parentpres.dta, clear
keep if inlist(wave,7,9)

cap drop py*
bysort cid (wave): gen pynrc = _n           	// observation ID (within child-parent dyad)
bysort id (wave): gen pynr = _n           		// observation ID (within child-parent dyad)
bysort cid: gen pycount = _N   					// # of observations (within child-parent dyad)

count 											// N=1,961 observations
tab pynrc if pynrc==1, m 					    // N=1,451 child-parent dyads
tab pynr 									    // N=1,031 anchor households


cd $path1	
use parentpres.dta, clear


*** Item-Nonresponse in outcome measures	(Footnote 7, Section 3.3)
tab1 csdq1i5 csdq1i12 csdq1i18 csdq1i22 csdq1i7, m
tab1 csdq1i3 csdq1i8 csdq1i13 csdq1i16 csdq1i24, m
tab1 csdq1i2 csdq1i10 csdq1i15 csdq1i21 csdq1i25, m
tab1 cpcr6i10 cpcr6i11 cpcr6i12, m
tab1 cpcr7i4 cpcr7i6, m

tab1 sdqpi5 sdqpi12 sdqpi18 sdqpi22 sdqpi7,m 
tab1 sdqpi3 sdqpi8 sdqpi13 sdqpi16 sdqpi24, m
tab1 sdqpi2 sdqpi10 sdqpi15 sdqpi21 sdqpi25 if inlist(wave,7,9), m
tab1 pcr1i3 pcr1i8 pcr1i11, m
tab1 pcr3i4 pcr3i6, m

tab1 pconduct pemotion pnegcomm pconflict, m
tab1 phyper if inlist(wave,7,9), m


***********************************
***	 Table 1: Cronbach's Alpha  ***
***********************************

** Across panel waves, based on full sample

** Conduct problems
bysort wave: alpha csdq1i5 csdq1i7_r csdq1i12 csdq1i18 csdq1i22		// .49 - .54	Child
bysort wave: alpha sdqpi5  sdqpi7_r   sdqpi12  sdqpi18  sdqpi22 	// .56 - .60	Parent

** Hyperactivity
bysort wave: alpha csdq1i2 csdq1i10 csdq1i15 csdq1i21_r csdq1i25_r	// .71 -.73, only considering waves 7 and 9 as parent reports are only available for W7,9
bysort wave: alpha sdqpi2   sdqpi10  sdqpi15  sdqpi21_r  sdqpi25_r	// .80 -.82, only considering waves 7 and 9 as parent reports are only available for W7,9

** Emotional symptoms
bysort wave: alpha csdq1i3 csdq1i8 csdq1i13 csdq1i16 csdq1i24		// .66 -.68		Child
bysort wave: alpha  sdqpi3  sdqpi8  sdqpi13  sdqpi16  sdqpi24		// .72 -.74		Parent

** Negative communication
bysort wave: alpha cpcr6i10 cpcr6i11 cpcr6i12						// .56 -.64		Child
bysort wave: alpha pcr1i3 pcr1i8 pcr1i11							// .69 -.75		Parent

** Conflicts
bysort wave: alpha cpcr7i4 cpcr7i6									// .71 -.73		Child
bysort wave: alpha  pcr3i4  pcr3i6									// .76 -.81		Parent



****************************************************************
***  Descriptive Statistics: Parental Presence (Section 4.1) ***
****************************************************************

** Third-party presence
tab1 cint1i*, m
egen byst=anycount(cint1i2 cint1i3 cint1i4 cint1i5), values(1)
tab byst
recode byst (2 3 4=1)
tab byst										// 40.9% of all child interviews are not conducted in private
tab byst cint1i1								

tab pres, m										// Parent presence: 39.1%
tab wave pres, row								// 40-37%
bysort demodiff: tab wave pres, row
tab pres demodiff, col chi2

tab byst pres, col chi2

** Sibling presence
tab cint1i3, m
tab cint1i3										// Sibling presence: 7.5%
tab pres cint1i3
tab wave cint1i3, row

** Other persons/family members present
gen other=.
replace other=0 if cint1i4==0 & cint1i5==0
replace other=1 if cint1i4==1 | cint1i5==1
tab other										// Other persons present: 0.8%
tab wave other, row

** Interruptions
tab cint2, m
gen interf=cint2
recode interf (-3=.) (1 2 =1) (3=0)
bysort wave: tab interf, m
tab interf cint2, m			
tab interf byst, m							
tab interf										// 7.7 % interruptions (of interviews with bystander presence)
tab interf pres, col chi2						// almost entirely in interviews with parental presence

tab nbpart interf, m
tab nbpart interf, row
tab nbpart interf, col							// Interruptions most frequent at first child interview: 35.9%
tab nbpart interf if pres==1, m
tab nbpart interf if pres==1, col				

** Number of interviews for children entering the study in waves 6-9
gen nbpart1=.
replace nbpart1=nbpart  if wave==6 & nbpart==1
replace nbpart1=nbpart  if wave==7 & nbpart<=2
replace nbpart1=nbpart  if wave==8 & nbpart<=3
replace nbpart1=nbpart  if wave==9 & nbpart<=4
tab nbpart1, m
tab nbpart1
tab nbpart1 byst

** Considering only children who participate from wave 6 onwards

tab byst if nbpart1!=.					// 48.2% bystander presence
tab pres if nbpart1!=.					// 46.1% parental presence
tab interf byst if nbpart1!=., m		// 97 missing values for variable on disruptions (n=621)
tab interf nbpart1, m
tab interf nbpart1
tab interf if nbpart1!=.				// 11.0% interruptions (n=68)
tab nbpart1 interf, col					// Interruptions mainly at first child interview: 48.5% (of interviews with bystander presence)



***************************************************************************************************
***  Table 2, Section 4.1: Differences by parental presence; Percent/Mean of observations (SD)  ***
***************************************************************************************************


** Assertiveness, Monitoring, intimacy, autonomy
ttest assertive, by(pres)
makematrix , from(r(mu_1) r(mu_2)) format(%6.2f): ttest assertive, by(pres)

ttest monitor, by(pres)
makematrix , from(r(mu_1) r(mu_2)) format(%6.2f): ttest monitor, by(pres)

ttest intim, by(pres)
makematrix , from(r(mu_1) r(mu_2)) format(%6.2f): ttest intim, by(pres)

ttest auton, by(pres)
makematrix , from(r(mu_1) r(mu_2)) format(%6.2f): ttest auton, by(pres)


** Child's number of interviews
ttest nbpart, by(pres)
makematrix , from(r(mu_1) r(mu_2)) format(%6.2f): ttest nbpart, by(pres)


** Child's number of interviews for children entering the study in waves 6-9
tab nbpart wave, m
tab nbpart pres, col chi2
cap drop nbpart1
gen nbpart1=.
replace nbpart1=nbpart  if wave==6 & nbpart==1
replace nbpart1=nbpart  if wave==7 & nbpart<=2
replace nbpart1=nbpart  if wave==8 & nbpart<=3
replace nbpart1=nbpart  if wave==9 & nbpart<=4

tab wave nbpart1, m
tab nbpart nbpart1, m

tab nbpart1 pres, col chi2


** Child's Age (years)
tab agekat4 pres, col chi2



**************************************************************************************************************************
***  Appendix Table A1: Child and parent reports on problem behavior and the parent-child relationship, full sample    ***
**************************************************************************************************************************

** Baseline levels of parent/child reports on children's problem behavior and problems in the parent-child relationship
foreach var of varlist conduct pconduct hyper phyper emotion pemotion negcomm pnegcomm conflict pconflict{
	sum `var'
}

** Mean child-parent difference: Two-sample t-tests (unpaired)
ttest conduct==pconduct, unpaired
ttest hyper==phyper, unpaired
ttest emotion==pemotion, unpaired 
ttest negcomm==pnegcomm, unpaired
ttest conflict==pconflict, unpaired 

** Spearman's correlation
spearman conduct pconduct 		if conduct!=. & pconduct!=.
spearman hyper phyper 			if hyper!=.   & phyper!=.
spearman emotion pemotion 		if emotion!=. & pemotion!=.
spearman negcomm pnegcomm 		if negcomm!=. & pnegcomm!=.
spearman conflict pconflict 	if conflict!=. & pconflict!=.




*******************************************************************************************	
***	 Figure 1, Section 4.1: Child-parent reporting discrepancies by parental presence   ***
*******************************************************************************************

cd $path1	
use parentpres.dta, clear

keep id cid wave pres diff* 
sort id wave

ttest diffext, by(pres) 
ttest diffhyper, by(pres)
ttest diffint, by(pres)

ren diffext temp1
ren diffhyper temp2
ren diffint temp3

save temp1.dta, replace

forvalues y=1/3{
	cd $path1	
	use temp1.dta, clear
		
	local varname1 temp`y'
	ttest temp`y', by(pres)
	anova temp`y' pres 
	test pres
	local pv`y' = round(Ftail(r(df), r(df_r),r(F)), .001)
	
	collapse (mean) meantemp= `varname1' (sd) sdtemp=`varname1' (count) n=`varname1', by(pres)

	generate hitemp = meantemp + invttail(n-1,0.025)*(sdtemp / sqrt(n))
	generate lowtemp = meantemp - invttail(n-1,0.025)*(sdtemp / sqrt(n))

	gen dim=`y'
	save est`y', replace
}

use est1, clear 
for num 2/3: append using estX

generate dimmod = pres+2    if dim == 1
replace  dimmod = pres+5    if dim == 2
replace  dimmod = pres+8    if dim == 3

sort dimmod

cd $path2	
twoway (dot meantemp dimmod if pres==0 , msize(medlarge) msymbol(Oh)  mcolor(black)) ///
       (dot meantemp dimmod if pres==1 , msize(med) msymbol(S) mcolor(black)) ///
       (rcap hitemp lowtemp dimmod, lcolor(gs4) lwidth(med)), ///
	   ylabel(-0.4 "-0.4" -0.3 "-0.3" -0.2 "-0.2" -0.1 "-0.1" 0 "0" 0.1 "0.1" 0.2 "0.2" 0.3 "0.3", angle(0) labsize(med)) ///
	   yline(0, lcolor(gs7)) ///
       legend(off) ///
       xlabel(2.7 `""Conduct""Problems""' 5.4 "Hyperactivity" 8.3 `""Emotional""Problems""', angle(0) noticks norescale labsize(med) labgap(2.5) ) ///
       xtitle("")  ytitle("Mean Child-Parent Diff. Score, 95% CI", size(medlarge))	 ///
	   text(-0.11 3.4 "p = `pv1'", place(w) size(med)) ///
	   text(-0.11 6 "p = `pv2'", place(w) size(med)) ///
	   text(-0.11 9 "p = `pv3'", place(w) size(med))  ///
	   graphregion(color(white)) ///
	   saving(Pbpres, replace)

	   
cd $path1	
use parentpres.dta, clear

keep id cid wave pres diff* 
sort id wave

ttest diffnegcomm, by(pres)
ttest diffconflict, by(pres)

ren diffnegcomm  temp4
ren diffconflict temp5

save temp2.dta, replace

forvalues y=4/5{
	cd $path1	
	use temp2.dta, clear
		
	local varname1 temp`y'
	ttest temp`y', by(pres)
	anova temp`y' pres 
	test pres
	local pv`y' = round(Ftail(r(df), r(df_r),r(F)), 0.001)
	
	collapse (mean) meantemp= `varname1' (sd) sdtemp=`varname1' (count) n=`varname1', by(pres)

	generate hitemp = meantemp + invttail(n-1,0.025)*(sdtemp / sqrt(n))
	generate lowtemp = meantemp - invttail(n-1,0.025)*(sdtemp / sqrt(n))

	gen dim=`y'
	save est`y', replace
}

use est4, clear 
append using est5

generate dimmod = pres+2    if dim == 4
replace  dimmod = pres+5    if dim == 5

sort dimmod

cd $path2	
twoway (dot meantemp dimmod if pres==0 , msize(medlarge) msymbol(Oh)  mcolor(black)) ///
       (dot meantemp dimmod if pres==1 , msize(med) msymbol(S) mcolor(black)) ///
       (rcap hitemp lowtemp dimmod, lcolor(gs4) lwidth(med)), ///
	   ylabel(-0.6 "-0.6" -0.5 "-0.5" -0.4 "-0.4" -0.3 "-0.3" -0.2 "-0.2" -0.1 "-0.1" 0 "0" 0.1 "0.1" 0.2 "0.2" 0.3 "0.3" 0.4 "0.4", ///
	   angle(0) labsize(med)) ///
	   yline(0, lcolor(gs7)) ///
       legend(order( 1 "Not present" 2 "Present") ring(0) pos(13) bplacement(neast) col(1) size(med)) ///
       xlabel(2.7 `""Negative""Communication""' 5.4 "Conflicts" , angle(0) noticks norescale labsize(med) labgap(2.5) ) ///
       xtitle("")  ytitle("Mean Child-Parent Diff. Score, 95% CI", size(medlarge))	 ///
	   text(-0.55 2.6 "p = `pv4'", place(c) size(med)) ///
	   text(-0.55 5.5 "p = `pv5'", place(c) size(med)) ///
	   graphregion(color(white)) ///
	   saving(Relpres, replace)

cd $path2		
graph combine Pbpres.gph Relpres.gph, graphregion(color(white)) 
*graph export Figure1.emf, replace
graph export Figure1.pdf, replace	
	   

cd $path1
for num 1/2: erase tempX.dta
for num 1/5: erase estX.dta
	   
	   

****************************************************************************************
*** 	Appendix Figure A1: Child-parent reporting discrepancies by child’s age 	 ***
****************************************************************************************

cd $path1	
use parentpres.dta, clear

bysort kagen: sum diffext
bysort kagen: sum diffhyper
bysort kagen: sum diffint
bysort kagen: sum diffnegcomm
bysort kagen: sum diffconflict



foreach var of varlist diffext diffhyper diffint diffnegcomm diffconflict{
	egen mean`var' = mean(`var'), by(kagen)
}

egen tag = tag(kagen)

cd $path2	
twoway (connected meandiffext   kagen if tag, msize(med) mcolor(gs7) lcolor(gs7) lwidth(medthick)) ///
	   (connected meandiffhyper kagen if tag, msize(med) mcolor(black) lcolor(black) lwidth(medthick)) ///
	   (connected meandiffint 	kagen if tag, msize(med) mcolor(gs10) lcolor(gs10) lwidth(medthick)),  ///
		ylabel(-0.3 "-0.3" -0.2 "-0.2" -0.1 "-0.1" 0 "0" 0.1 "0.1" 0.2 "0.2" 0.3 "0.3" 0.4 "0.4" 0.5 "0.5", ///
		angle(0) labsize(med)) ///
		yline(0, lcolor(black)) ///
		xlabel(8 "8" 9 "9" 10 "10" 11 "11" 12 "12" 13 "13" 14 "14" 15 "15")	///
		xtitle("Child's Age", size(med) margin(0 0 0 2))  ytitle("Mean Child-Parent Diff. Score", size(medlarge))	 ///
		legend(order( 1 "Conduct Problems" 2 "Hyperactivity" 3 "Emotional Problems") ring(0) pos(13) bplacement(neast) col(1) size(med)) ///
		graphregion(color(white)) ///
		saving(Pbage, replace)
		
cd $path2	
twoway (connected meandiffnegcomm  kagen if tag, msize(med) mcolor(black) lcolor(black) lwidth(medthick)) ///
	   (connected meandiffconflict kagen if tag, msize(med) mcolor(gs7) lcolor(gs7) lwidth(medthick)), ///
		ylabel(-0.8 "-0.8" -0.7 "-0.7" -0.6 "-0.6" -0.5 "-0.5" -0.4 "-0.4" -0.3 "-0.3" -0.2 "-0.2" -0.1 "-0.1" 0 "0" 0.1 "0.1" 0.2 "0.2" 0.3 "0.3" 0.4 "0.4" , ///
		angle(0) labsize(med)) ///
		yline(0, lcolor(black)) ///
		xlabel(8 "8" 9 "9" 10 "10" 11 "11" 12 "12" 13 "13" 14 "14" 15 "15")	///
		xtitle("Child's Age", size(med) margin(0 0 0 2))  ytitle("Mean Child-Parent Diff. Score", size(medlarge))	 ///
		legend(order( 1 "Neg. Communication" 2 "Conflicts") ring(0) pos(13) bplacement(neast) col(1) size(med)) ///
		graphregion(color(white)) ///
		saving(Relage, replace)

cd $path2
graph combine Pbage.gph Relage.gph, graphregion(color(white)) 
*graph export AppFigure1.emf, replace	
graph export AppFigure1.pdf, replace	

